this.name			= "AsteroidStorm";
this.author			= "Dajt, Kaks, LittleBear";
this.copyright		= "Creative Commons: attribution, non-commercial, sharealike.";
this.description	= "A mission to save a space station, original script.js (Oolite 1.65-js) by Dajt, updated & expanded by Kaks.";
this.version		= "3.46";

this.minOolite="1.71";
this.directory="AddOns/AsteroidStorm/Config";
this.readme="asteroids_cantrun";

// declare working variables
this.badrocks=["badrockI","badrockII","badrockIII"];
this.badrock="";
this.lasthit="";
this.sys=system;
this.doingMissionScreen = false // Set to true when starting a mission screen


this.showReadme=function(){
	//mission.clearMissionScreen();
	mission.showMissionScreen();
	mission.addMessageTextKey(this.readme);
}

this.canRun = function(){
	//whole scripts fail in pre170, no need to check for those anymore
	if (oolite.compareVersion(minOolite) > 0){
		log("script."+this.name, "--- Script disabled. Requires Oolite v"+this.minOolite+".\n\t\tTo enable legacy script.plist, go to "+this.directory+"\n\t\tand rename world-scripts.js to ~world-scripts.js");
		return false;
	}
	if (oolite.compareVersion("1.72") == 0){
		log("script."+this.name, "--- Script disabled. Incompatible with Oolite v 1.72. Use 1.71 or 1.72.1 or newer.\n\t\tTo enable legacy script.plist, go to "+this.directory+"\n\t\tand rename world-scripts.js to ~world-scripts.js");
		return false;
	}
	return true;
}

this.anyInt= function(n1,n2){
		return Math.round(Math.random()*(n2-n1)+n1);
}

this.changeInfo = function(){
        var d="The planet Leesti is reasonably fabled for Zero-G cricket and Leestiian evil juice, but cursed by deadly asteroid storms. Leesti's orbital station was recently destroyed by a large asteroid strike. Ships without planet landing capabilities are therefore advised to avoid this system."
        if(0<oolite.compareVersion("1.72"))
        {
            player.call("setSpecificPlanetInfo:", "0=55=station=none");
            player.call("setSpecificPlanetInfo:", "0=55=description="+d);
        }
        else
        {
			system.infoForSystem(0, 55).station = "none"
			system.infoForSystem(0, 55).description = d
        }
}

this.wipeStationReally=function (){
	this.wipeStation(true);
}

this.wipeStation=function (really,that) {
	missionVariables.asteroids = "asteroids_OVER";
	missionVariables.asteroids_statdead =1;
	var d="The planet Leesti is reasonably fabled for Zero-G cricket and Leestiian evil juice, but cursed by deadly asteroid storms. Leesti's orbital station was recently destroyed by a large asteroid strike. Ships without planet landing capabilities are therefore advised to avoid this system.";
        if(oolite.compareVersion("1.72") > 0)
        {
            player.call("setSpecificPlanetInfo:", "0=55=station=none");	
            player.call("setSpecificPlanetInfo:", "0=55=description="+d);
        }
        else
        {
			system.description = d;
			system.info.station = "none";
        }
	system.description=d;//refreshes info screen immediately!
	if (system.mainStation) 
		{
		if(oolite.compareVersion("1.72") > 0)
			system.mainStation.shipDisplayName="Damaged Leesti High";
		else
			system.mainStation.displayName="Damaged Leesti High";
		}
	if (system.shipsWithRole("aststat").length>0){
		if (Math.random()<.25||really){
			var pos=system.mainStation.position;
			System.mainStation.explode()
			system.legacy_addShipsAtPrecisely("station-alloy", 50, "abs", pos);
			var tmp=system.shipsWithRole("station-alloy");
			for (var i=0; i<tmp.length; i++)
				if(tmp[i].isValid){ //could have already been destroyed
					tmp[i].setPosition(pos.add([anyInt(-i,1+i)*5, anyInt(-i,1+i)*5, anyInt(-i,1+i)*5]));
				}
		} else{
			if(!that) that=this;
			that.sys.description=d.replace(/was recently destroyed by/,"is currently being evacuated after");
			if(oolite.compareVersion("1.72") > 0)
				that.sys.mainStation.call("commsMessage:","MAIN REACTOR BREACH, EXPLOSION IMMINENT!");
			else
				that.sys.mainStation.commsMessage("MAIN REACTOR BREACH, EXPLOSION IMMINENT!");
			that.timer=new Timer(that, that.wipeStationReally,that.anyInt(18, 38));
		}
	} else
		system.legacy_addSystemShips("alloy", 50, 1); //should work even with a missing station.
}


this.shipWillLaunchFromStation = function(station){
	this.cleanup();
}

this.missionOffers = function(){
	// Don't offer the missions when showing a mission screen  or mission.choice needs processing
	// wait until called again via missionScreenEnded, next docking, or missionChoiceWasReset
	if (this.myMissionShown || guiScreen == "GUI_SCREEN_MISSION" || (mission.choice && mission.choice != "")) return;
	{
		if (!this.playerShip.dockedStation.isMainStation) return;
		if(system.ID==55 && galaxyNumber==0){
			if(!missionVariables.asteroids && player.score>63){
				missionVariables.asteroids="asteroids_BRIEFED";
				missionVariables.asteroids_statdead =
				missionVariables.asteroids_bombremoved =
				missionVariables.asteroids_rockdead = 0;
				mission.runMissionScreen("asteroidsbrief_1", "GalCop.png", null, this.badrocks[0], "warning.ogg") // "son et lumiere" :)
			}
			if(missionVariables.asteroids=="asteroids_RUNNING"){
				// do we still have a doomsday asteroid?
				if(system.shipsWithRole(this.badrock).length>0)
					mission.runMissionScreen("asteroidsbrief_2", "GalCop.png", null, null, "warning.ogg");  //get back out!
				else {// inside the station, mission running, but no asteroid. this should never happen 
					missionVariables.asteroids = "asteroids_OVER";
					missionVariables.asteroids_rockdead=1;
					this.myMissionShown= true;
				}
			}
		} 
		
		if(missionVariables.asteroids && missionVariables.asteroids != "asteroids_FINISHED") {
			if(missionVariables.asteroids == "asteroids_COWARD"){
				player.credits -= 200;
				player.bounty += 25;
				missionVariables.asteroids = "asteroids_FINISHED";
				mission.runMissionScreen("asteroidsbrief_3", "GalCop.png");
				this.myMissionShown= true;
			}
			if(missionVariables.asteroids == "asteroids_OVER"){
				if(missionVariables.asteroids_statdead==1){ //0 or 1
					var stationName = ""
					if(oolite.compareVersion("1.72") > 0) stationName = system.mainStation.shipDescription
					else stationName = system.mainStation.name
					if (stationName.indexOf("Leesti")>0){ //"damaged leesti"
						//inside the damaged station.
						this.timer.stop();
						this.byeStation=true;
						if (missionVariables.asteroids_bombremoved>0){
							this.playerShip.awardEquipment("EQ_ENERGY_BOMB");
						}
						mission.runMissionScreen("asteroidsbrief_7", "GalCop.png"); //we're doomed!
					}else 
						mission.runMissionScreen("asteroidsbrief_4", "GalCop.png"); //you tried!
					player.credits += 200;
					if(system.ID!=55 || galaxyNumber!=0) //we saw the doomed station, didn't bother to go in
						this.changeInfo();
				} else if (missionVariables.asteroids_rockdead==1){
					if(this.lasthit=="player"){
						player.credits+=1000;
						player.bounty=0;
						mission.runMissionScreen("asteroidsbrief_5", "GalCop.png");//you did it!
						this.playerShip.awardEquipment("EQ_ENERGY_BOMB");
					} else {
						player.credits += 350;
						mission.runMissionScreen("asteroidsbrief_6", "GalCop.png");//you helped doing it!
						if (missionVariables.asteroids_bombremoved>0){
							this.playerShip.awardEquipment("EQ_ENERGY_BOMB");
						}
					}
				}
				missionVariables.asteroids = "asteroids_FINISHED";
				this.myMissionShown= true;
			}
		}
	}
} 

this.missionScreenEnded = function(){
	if(!this.playerShip.docked) return;
	this.missionOffers()
}
this.missionChoiceWasReset = function(){
	if(!this.playerShip.docked) return;
	this.missionOffers()
}

/*
Credits to Kaks. Below Kaks uses a very complicated method to set properties of the badrock from
within this worldScript. In current Oolite versions one can do this much easier, but Kaks had to use
this complex way to let it work with Oolite 1.70. Part of the complexity I wrote out of it and part I 
let in as a tribute to Kaks who left some very nice sample code with it.
All b.xxx become properties of the rock itself and can be used in that ship script.
Without this missionVariables. and System. could not reliable be used in oolite 1.70 ship scripts.
Eric Walch
*/
this.doomRocks=function(){
	missionVariables.asteroids = "asteroids_RUNNING";
	system.legacy_addSystemShips("ast1",27,1);
	system.legacy_addSystemShips(this.badrock,1,1);
	var b=system.shipsWithRole(this.badrock)[0];
	b.vars=missionVariables;
	b.sys=system;
	b.that=this;
	b.wipeStation=this.wipeStation;
	var d=b.position.subtract(system.mainStation.position);
	if(d.magnitude()>20000){
		d=d.multiply(.35);
		b.setPosition(b.position.subtract(d));
		b.switchAI("JSbadrockAI.plist");
	}
	b.recharge=(d.magnitude()/7000)-1; //rough estimate
}
this.DISABLE=function(name){
	if (!this.old) this.old={};
	if (!name || name=="") return;
	if (!this.old[name])
		this.old[name]=this[name];
	//this[name]=function(){};
	delete this[name];
}
this.ENABLE=function(name){
	if (!name || name==""||!this.old) return;
	this[name]=this.old[name];
}
this.CLEANUP = function(){ //can't check missionVariables inside startUp or reset
	if (missionVariables.asteroids == "asteroids_FINISHED" || (galaxyNumber>0 && galaxyNumber<7)){
            log("script.AsteroidStorm.cleanup", "Asteroid Storm finished, or player in another galaxy. Disabling script.");
		//no need to run any of these!
		this.DISABLE("shipDockedWithStation");	
		this.DISABLE("shipLaunchedFromStation");
		this.DISABLE("shipWillEnterWitchspace");
		this.DISABLE("missionScreenEnded");
	} else if (missionVariables.asteroids){
		if (missionVariables.asteroids != "asteroids_FINISHED" && this.old){
			this.ENABLE("shipDockedWithStation");	
			this.ENABLE("shipLaunchedFromStation");
			this.ENABLE("shipWillEnterWitchspace");
			this.ENABLE("missionScreenEnded");		
			log("script.AsteroidStorm.cleanup", "Asteroid Storm script disabled previously. Re-enabling script.");
		}
		this.byeStation=0;//might not be needed...
	}
	this.cleanup=function(){}; // run just once per script startup/reset
}

this.startUp = function(){
	if(player.hasOwnProperty("ship")) this.playerShip = player.ship
	else this.playerShip = player;
	this.reset()
}

this.reset = function(){
	if (!this.canRun()){
		//disable the events - tell them why!
		delete this.shipDockedWithStation;	
		delete this.shipLaunchedFromStation;
		delete this.shipWillEnterWitchspace;
		delete this.shipExitedWitchspace;
		delete this.missionScreenEnded;
		this.timer=new Timer(this, this.showReadme,.01);//doesn't work if called directly!
	} else {
		// can't access the missionVariables from here, so I'll have to use a use-once function
		this.cleanup=this.CLEANUP;
	}
}

this.shipDockedWithStation = function(){
	this.myMissionShown=false;
	if(!this.playerShip.docked) return; // could have been launched by an other script!
	this.missionOffers();
}

this.shipLaunchedFromStation = function(){
	if(system.ID==55 && galaxyNumber==0){
		if(this.byeStation){
			this.timer=new Timer(this, this.wipeStationReally, this.anyInt(3,19));
			return;
		}
		if( system.countShipsWithRole("ast1")<3)
			system.legacy_addSystemShips("ast1", 3, 0.9);
		if (missionVariables.asteroids == "asteroids_RUNNING"|| missionVariables.asteroids == "asteroids_BRIEFED"){
			if (this.playerShip.hasEquipment("EQ_ENERGY_BOMB")){
				this.playerShip.removeEquipment("EQ_ENERGY_BOMB");
				missionVariables.asteroids_bombremoved=1;
			}
			if (this.badrock=="") // choose once.
				this.badrock=player.score>95?this.badrocks[2]:this.badrocks[1]; // v. strong / strong rock
			if (system.shipsWithRole(this.badrock).length==0)
				this.doomRocks();
		}
	}
}

this.shipWillEnterWitchspace = function(){
	if (missionVariables.asteroids == "asteroids_RUNNING"){
		if(system.shipsWithRole(this.badrock).length ==0)
			missionVariables.asteroids = "asteroids_OVER";
		else{
			missionVariables.asteroids = "asteroids_COWARD";
			missionVariables.asteroids_statdead=1;
			this.changeInfo();
		}
	}
}

this.shipWillExitWitchspace = function(){
	if(system.ID==55 && galaxyNumber==0){
		system.legacy_addSystemShips("ast1", 3, 0.9);
		system.legacy_addSystemShips("ast1", 2, 0.6);
		system.legacy_addSystemShips("ast1", 2, 0.4);
		system.legacy_addSystemShips("ast1", 2, 0.2);
		system.legacy_addSystemShips("ast1", 4, 0.1);
		system.legacy_addSystemShips("asteroid", 3, 0);
		if(missionVariables.asteroids_statdead && missionVariables.asteroids_statdead ==1){
		// Find all stations and dockable items in the system.
		var stations = system.filteredEntities(this, function (entity) { return entity.isStation; });
		// Blow them all up.
		stations.forEach(function (entity) { entity.explode(); });
		}
	}
}